﻿using System;
using System.IO;
using System.Net.Sockets;
using System.Threading;

public class ServerClient
{
    private const int _CLIENTID = 1;
    private int _taskCount = 0;
    private Graphics _graphics;
    private StreamReader _input;
    private StreamWriter _output;
    private TcpClient _clientSocket;

    public ServerClient(Graphics graphics)
    {
        _graphics = graphics;
        _clientSocket = new TcpClient();
    }

    public bool connect()
    {
        try
        {
            _clientSocket.Connect("127.0.0.1", 50011);
            _input = new StreamReader(_clientSocket.GetStream(), System.Text.Encoding.ASCII);
            _output = new StreamWriter(_clientSocket.GetStream());

            return true;
        }
        catch
        {
            return false;
        }
    }

    public void close()
    {
        _input.Close();
        _output.Close();
        _clientSocket.Close();
    }

    public void stopPlayBack()
    {
        string serverClient = "<task name=\"" + "STOP_PLAYBACK" + "\" ownerId=\"" + _CLIENTID + "\" taskId=\"" + (_taskCount + 1000000 * _CLIENTID) + "\">" + "</task>";
        
        _taskCount++;
        _output.WriteLine(serverClient);
        _output.Flush();
    }

    public void sendAndPlayScript(string script, int groupID)
    {
        /*string serverClient = "<task name=\"" + "UPLOAD_SCRIPT" + "\" ownerId=\"" + _CLIENTID + "\" taskId=\"" + (_taskCount + 1000000 * _CLIENTID) + "\">";
        serverClient += "<param>" + script + "</param>";
        serverClient += "<param>" + "SMIL-Agent" + "</param>";
        serverClient += "</task>";

        _taskCount++;
        _output.WriteLine(serverClient);
        _output.Flush();

        char[] buffer = new char[1024];
        _input.ReadBlock(buffer, 0, 72);

        serverClient = "<task name=\"" + "RESUME_PLAYBACK" + "\" ownerId=\"" + _CLIENTID + "\" taskId=\"" + (_taskCount + 1000000 * _CLIENTID) + "\">" + "</task>";

        _taskCount += 3;
        _output.WriteLine(serverClient);
        _output.Flush();

        buffer = new char[1024];
        _input.ReadBlock(buffer, 0, 74);*/
        if (groupID == 0 || groupID == 8 || groupID == 9 || groupID == 10)
        {
            _graphics.getMainForm().Invoke(new Graphics.loadNextSceneDelegate(_graphics.loadNextScene));
        }
        else if (groupID == -1)
        {
            _graphics.getMainForm().Invoke(new Graphics.setupPhysiciansNumberDelegate(_graphics.setupPhysiciansNumber), "NEXTSCENE");
        }
        else if (groupID == -2)
        {
            _graphics.getMainForm().Invoke(new Graphics.setupNamePromptDelegate(_graphics.setupNamePrompt), "NEXTSCENE");
        }
        else if (groupID == 1)
        {
            _graphics.getMainForm().Invoke(new Graphics.addContinueButtonDelegate(_graphics.addContinueButton));
        }
        else if (groupID == 3)
        {
            _graphics.getMainForm().Invoke(new Graphics.setupPedometerReadingDelegate(_graphics.setupPedometerReading));
        }
        else if (groupID == 5)
        {
            _graphics.getMainForm().Invoke(new Graphics.loadAndPlayEndingVideoDelegate(_graphics.loadAndPlayEndingVideo));
        }
        else if (groupID == 6)
        {
            _graphics.getMainForm().Invoke(new Graphics.setupNamePromptDelegate(_graphics.setupNamePrompt), "CURRENT");
        }
        else if (groupID == 10)
        {
            _graphics.getMainForm().Invoke(new Graphics.continueAfterIntroScriptDelegate(_graphics.continueAfterIntroScript));
        }
        else if (groupID == 11)
        {
            _graphics.getMainForm().Invoke(new Graphics.setupPhysiciansNumberDelegate(_graphics.setupPhysiciansNumber), "CURRENT");
        }
    }
}